<?LassoScript
// Prepared for Lasso Summit 2006
// by Eric Landmann, Landmann InterActive, elandmann@landmanninteractive.com

// DEVEL NOTES
// Only JPEG files are currently supported.
// Others could be added easily if you check for the filetype and issue the correct ImageMagick command

// VERSION NOTES
// This has been tested with ImageMagick versions 6.1.5 and 6.2.0, and PassThru 2.5.8 on Lasso 8.0 and 8.1

// Defining thumbnail sizes
Local:'largewidth' = (integer),
	'largeheight' = (integer),
	'mediumwidth' = (integer),
	'mediumheight' = (integer),
	'thumbwidth' = (integer),
	'thumbheight' = (integer),
	'largewidth' = '800',
	'largeheight' = '800',
	'mediumwidth' = '400',
	'mediumheight' = '400',
	'thumbwidth' = '110',
	'thumbheight' = '110',
	'converting' = (string);

// DestPath is the upload directory
// ProcessedPath is the path where high-res files are stored after they are processed
// ThisFile is used as a counter variable in an interation through the File Uploads array
// FileName is the name of the temporary file Lasso creates, e.g. "///var/tmp/lasso0tmpH0QIPH46243328.uld"
// FileType is the type of file, e.g. .jpg
// FileSize is the size in bytes of the uploaded file
// FileReal is the actual file name of the uploaded file, e.g. Asymmetric_Warfare_MG.jpg
// FileField is the name of the form element for the file that was uploaded
// NewFileName is the name of the file renamed with the unique extension, e.g. Asymmetric_Warfare_MG_2F8.jpg
// ThisImageInfo is used to capture information about an uploaded image, including file type, height and width
Local:'DestPath' = '/upload/',
	'ProcessedPath' = '/upload_processed/',
	'ThisFile' = (string),
	'FileName' = (string),
	'FileType' = (string),
	'FileSize' = (string),
	'FileReal' = (string),
	'FileRealRaw' = (string),
	'FileField' = (string),
	'NewFileName' = (string),
	'ThisImageInfo' = (null);

// Authenticate for file operations
Inline: -Username=$svFileUsername, -Password=$svFilePassword;

	If: (File_Uploads->Size) != 0;

		Iterate: (File_Uploads), #ThisFile;

			#FileName = #ThisFile->(Find: 'upload.name');
			#FileType = (#ThisFile->(Find: 'upload.type')->split:'/')->last;
			#FileSize = #ThisFile->(Find: 'upload.size');
			#FileField = #ThisFile->(Find: 'upload.fieldname');
			#FileRealRaw = #ThisFile->(Find: 'upload.realname');

			// If FileType NOT .jpg, generate Error 5060 "Illegal FileType" error immediately and redirect to form
			If: (#FileType != 'JPEG');
				$vError == '5060';
			Var:'URL'=('/upload_images.lasso?Error='$vError'&Option='$vOption'&Area='$vArea'&Crag='$vCrag'&RouteID='$vRouteID'&ImageTitle='$vImageTitle'&Caption='$vCaption'&ImageCredits='$vImageCredits)'&Process=Y';

				If: $svDebug == 'Y';
					'<p class="debug">\n';
					'69: URL = <a href="' $URL '">' $URL '</a><br>';
					'</p>\n';
					Abort;
				Else;
					Redirect_URL: $URL;
				/If;
			/If;

			// Clean up the FileName
			Local:'FileReal' =
				(String_ReplaceRegExp:(Encode_StrictURL: $FileRealRaw->(Split:'\\')->Last),
				-Find='%[\\da-f]{2}',-Replace='');
			#FileReal->Trim;

			// Grab the prefix for the file (everything before the .) and build a new unique outfile name	
			Local:'FilePrefix' = (#FileReal->(Split: '.'));
			Local:'NewFileName' = ((#FilePrefix->Get:1) '_' (Create_UIDShort) '.jpg');
			If: $svDebug == 'Y';
				'<p class="debug">\n';
				'88: FileName = ' (#FileName) '<br>\r';
				'88: FilePrefix = ' (#FilePrefix) '<br>\r';
				'88: NewFileName = ' (#NewFileName) '<br>\r';
				'</p>\n';
			/If;
	
			// Concatonate the path and FileName
			// Filepath to the uploaded file should be something like "/uploads/P10839275.jpg"
			Local:'ThisFilePath' = (#DestPath) (#NewFileName);
			If: $svDebug == 'Y';
				'<p class="debug">\n';
				'99: ThisFilePath = ' (#ThisFilePath) '<br>\r';
				'</p>\n';
			/If;

			// Create the source file
			File_Create: (#ThisFilePath), -FileOverWrite;
			File_Write: (#ThisFilePath), (File_Read: (#FileName));

			// Defining variables for the destination files
			Local:'ULPathImageLargeOUT' = (($svWebserverRoot) ($svULpathImageLarge) (#NewFileName));
			Local:'ULPathImageMedOUT' = (($svWebserverRoot) ($svULpathImageMed) (#NewFileName));
			Local:'ULPathImageThumbOUT' = (($svWebserverRoot) ($svULpathImageThumb) (#NewFileName));

			// Get size and FileType info from the image
			// This is used below to check size of image to use appropriate resizing dimensions
			Local:'ThisImageInfo' = (Image:(#ThisFilePath), -Info);
			Local:'FileType' = #ThisImageInfo->Format;
			Local:'Height' = #ThisImageInfo->Height;
			Local:'Width' = #ThisImageInfo->Width;

			If: $svDebug == 'Y';
				'<p class="debug">\n';
				'119: ThisImageInfo = ' (#ThisImageInfo) '<br>\r';
				'119: FileType = ' (#FileType) '<br>\r';
				'119: Height = ' (#Height) '<br>\r';
				'119: Width = ' (#Width) '<br>\r';
				'</p>\n';
			/If;

			//  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
			//	Make Large version
			//  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
			If:(#Height < #largeheight) || (#Width < #largewidth);
				Local('ResizeTest') = 'Image Height or Width LESS THAN large image, make large version, no resize<br>\r';
				Local:'MakeLarge' = ($svPathToIM 'convert -density 72x72 -colorspace RGB "' ($svWebserverRoot) (#ThisFilePath) '" "' (#ULPathImageLargeOUT) '"');
			Else;
				Local('ResizeTest') = 'Image Height or Width GREATER THAN large image, make large version, resize 600x600<br>\r';
				Local:'MakeLarge' = ($svPathToIM 'convert -density 72x72 -colorspace RGB -resize ' (#largewidth) 'x' (#largeHeight)  ' "' ($svWebserverRoot) (#ThisFilePath) '" "' (#ULPathImageLargeOUT) '"');
			/If;

			If: $svDebug == 'Y';
				'<p class="debug">\n';
				'141: ResizeTest = ' (#ResizeTest) '<br>\r';
				'141: MakeLarge = ' (#MakeLarge) '<br>\r';
				'</p>\n';
			/If;

			// Run the PassThru command to convert the file
			Local('converting') = PassThru(#MakeLarge, -username=$svPassThruUsername, -password=$svPassThruPassword);

			//  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
			//	Make Medium version
			//  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
			Local('MakeMedium') = ($svPathToIM 'convert -density 72x72 -colorspace RGB -resize "' (#mediumWidth) 'x' (#mediumHeight) '" "' ($svWebserverRoot) (#ThisFilePath) '" "' (#ULPathImageMedOUT) '"');
			
			If: $svDebug == 'Y';
				'<p class="debug">\n';
				'156: MakeMedium = ' (#MakeMedium) '<br>\r';
				'</p>\n';
			/If;

			// Run the PassThru command to convert the file
			Local('converting') = PassThru(#MakeMedium, -username=$svPassThruUsername, -password=$svPassThruPassword);

			//  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
			//	Make Thumb version
			//  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
			Local('MakeThumb') = ($svPathToIM 'convert -density 72x72 -colorspace RGB -resize "' (#thumbWidth) 'x' (#thumbHeight) '" "' ($svWebserverRoot) (#ThisFilePath) '" "' (#ULPathImageThumbOUT) '"');
			
			If: $svDebug == 'Y';
				'<p class="debug">\n';
				'170: MakeThumb = ' (#MakeThumb) '<br>\r';
				'</p>\n';
			/If;

			// Run the PassThru command to convert the file
			Local('converting') = PassThru(#MakeThumb, -username=$svPassThruUsername, -password=$svPassThruPassword);

			// Archive the original upload file, if this option is set in the siteconfig
			If: $svArchiveOriginalUpload == True;

				// THIS WORKS with PaSSTHRU, but NOW TRYING WITH LASSO TAGS
				// Move the file to the upload_processed folder, it has already been renamed to a unique FileName
				// Local:'MoveProcessed' = ('cp "' (($svWebserverRoot) (#DestPath) (#NewFileName)) '" "' (($svWebserverRoot) (#ProcessedPath) (#NewFileName)) '"');
				// Local('MoveIt') = PassThru(#MoveProcessed, -username=$svPassThruUsername, -password=$svPassThruPassword);
				Local:('CopyFrom') = ((#DestPath) (#NewFileName));
				Local:('CopyTo') = ((#ProcessedPath) (#NewFileName));
				If: $svDebug == 'Y';
					'<p class="debug">\n';
					'188: CopyFrom: ' #CopyFrom '<br>\r';
					'188: CopyTo: ' #CopyTo '<br>\r';
					'</p>\n';
				/If;
				File_Copy: $CopyFrom, $CopyTo, -FileOverWrite;

			/If;

			// Delete the original file
			File_Delete: (#ThisFilePath);

			// If copy fails, set $vError to 5033 "File Error" and redirect
			If: ((File_CurrentError: -ErrorCode) != '0') || ((Error_CurrentError: -ErrorCode) != '0');
				Var:'vError' = '5033';
				Var:'URL'=('/upload_images.lasso?Error=5033'(Client_POSTArgs));
		
				If: $svDebug == 'Y';
					'<p class="debug">\n';
					'206: URL = <a href="' $URL '">' $URL '</a><br>';
					'</p>\n';
					Abort;
				Else;
					Redirect_URL: $URL;
				/If;
		
			// Else assume upload successful, set vError to 5061 "Upload Successful" and option to NewFileName
			Else;
				Var:'vError' = '5061';
				Var:'vOption' = (#NewFileName);
			/If;

		/iterate;

	Else;
	
		// File not uploaded because upload size = 0, so set $vError to 5033 "File Error" and redirect
		Var:'vError' = '5033';
		Var:'URL'=('/upload_images.lasso?Error='$vError'&Option='$vOption'&Area='$vArea'&Crag='$vCrag'&RouteID='$vRouteID'&ImageTitle='$vImageTitle'&Caption='$vCaption'&ImageCredits='$vImageCredits)'&Process=N';

		If: $svDebug == 'Y';
			'<p class="debug">\n';
			'229: URL = <a href="' $URL '">' $URL '</a><br>';
			'</p>\n';
			Abort;
		Else;
			Redirect_URL: $URL;
		/If;
	/If;

/inline;
?>
